/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.internal.handlers;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.terminal.TerminalPlugin;
import com.aptana.terminal.internal.handlers.Messages;
import com.aptana.terminal.views.TerminalView;
import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenTerminalHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart;
        Object selectedObject;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class);
            if (resource != null) {
                IContainer folder = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
                TerminalView.openView(folder.getName(), folder.getName(), folder.getLocation());
                return true;
            }
            IFileStore fileStore = (IFileStore)((IAdaptable)selectedObject).getAdapter(IFileStore.class);
            try {
                if (fileStore != null && fileStore.toLocalFile(0, null) != null) {
                    if (!fileStore.fetchInfo().isDirectory()) {
                        fileStore = fileStore.getParent();
                    }
                    TerminalView.openView(fileStore.getName(), fileStore.getName(), URIUtil.toPath((URI)fileStore.toURI()));
                    return true;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)TerminalPlugin.getDefault(), (Throwable)e);
            }
        }
        if ((editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event)) != null) {
            URI uri;
            IFileEditorInput fileInput;
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof IFileEditorInput) {
                fileInput = (IFileEditorInput)input;
                IContainer folder = fileInput.getFile().getParent();
                TerminalView.openView(folder.getName(), folder.getName(), folder.getLocation());
                return true;
            }
            if (input instanceof IStorageEditorInput) {
                fileInput = (IStorageEditorInput)input;
                try {
                    IPath fullPath;
                    IStorage storage = fileInput.getStorage();
                    if (storage != null && (fullPath = storage.getFullPath()) != null) {
                        IPath parentPath = fullPath.removeLastSegments(1);
                        TerminalView.openView(parentPath.lastSegment(), parentPath.lastSegment(), parentPath);
                        return true;
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)TerminalPlugin.getDefault(), (Throwable)e);
                }
            }
            if (input instanceof IPathEditorInput) {
                IPath path = ((IPathEditorInput)input).getPath();
                IPath parentPath = path.removeLastSegments(1);
                TerminalView.openView(parentPath.lastSegment(), parentPath.lastSegment(), parentPath);
                return true;
            }
            if (input instanceof IURIEditorInput && (uri = (fileInput = (IURIEditorInput)input).getURI()) != null && "file".equals(uri.getScheme())) {
                IPath path = Path.fromOSString((String)uri.getPath());
                IPath parentPath = path.removeLastSegments(1);
                TerminalView.openView(parentPath.lastSegment(), parentPath.lastSegment(), parentPath);
                return true;
            }
        }
        if (!this.openUserWorkingDirectory()) {
            TerminalView.openView(null, Messages.OpenTerminalHandler_LBL_Terminal, null);
        }
        return null;
    }

    private boolean openUserWorkingDirectory() {
        IPath workingDirectory;
        String workingDirectoryPref = Platform.getPreferencesService().getString("com.aptana.terminal", "com.aptana.terminal.workingDirectory", null, null);
        if (!StringUtil.isEmpty((String)workingDirectoryPref) && (workingDirectory = Path.fromOSString((String)workingDirectoryPref)).toFile().isDirectory()) {
            TerminalView.openView(null, Messages.OpenTerminalHandler_LBL_Terminal, workingDirectory);
            return true;
        }
        return false;
    }
}

